/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass._65xx._65xxArgType;
import kickass._65xx._65xxArgTypeUtil;
import kickass._65xx.cpus.CPU_6502WithIllegals;
import kickass._65xx.cpus.Cpu;
import kickass._65xx.cpus.MnemonicDefinition;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.values.NumberValue;
import kickass.state.libraries.AbstractLibrary;
import kickass.state.libraries.LibConstant;

public class MnemonicsLibrary
extends AbstractLibrary {
    private Map<Integer, Integer> opcodeToCmdSize = this.createOpcodeToCmdSizeMap(CPU_6502WithIllegals.instance);

    private Map<Integer, Integer> createOpcodeToCmdSizeMap(Cpu cpu) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (MnemonicDefinition mnemonicDefinition : cpu.mnemonics) {
            int[] nArray = mnemonicDefinition.opcodes;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0) continue;
                int n2 = _65xxArgTypeUtil.getArgType(i, null).getByteSize() + 1;
                hashMap.put(n, n2);
            }
        }
        return hashMap;
    }

    private int getOpcodeSize(int n) {
        Integer n2 = this.opcodeToCmdSize.get(n);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public List<LibConstant> getConstants() {
        ArrayList<LibConstant> arrayList = new ArrayList<LibConstant>();
        this.addOpcodeConstants(CPU_6502WithIllegals.instance, arrayList);
        return arrayList;
    }

    @Override
    public String getName() {
        return "65xxMnemonics";
    }

    private List<LibConstant> addOpcodeConstants(Cpu cpu, List<LibConstant> list) {
        for (MnemonicDefinition mnemonicDefinition : cpu.mnemonics) {
            for (String string : mnemonicDefinition.namesList) {
                int[] nArray = mnemonicDefinition.opcodes;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < 0) continue;
                    String string2 = string.toUpperCase();
                    if (i > 0) {
                        string2 = string2 + "_" + MnemonicsLibrary.typeToShortString(i);
                    }
                    list.add(new LibConstant(string2, new NumberValue(nArray[i])));
                }
            }
        }
        return list;
    }

    public static String typeToShortString(int n) {
        _65xxArgType _65xxArgType2 = _65xxArgTypeUtil.getArgType(n, null);
        switch (_65xxArgType2) {
            case noArgument: {
                return "NONE";
            }
            case immediate: {
                return "IMM";
            }
            case zeropage: {
                return "ZP";
            }
            case zeropageX: {
                return "ZPX";
            }
            case zeropageY: {
                return "ZPY";
            }
            case indirectZeropageX: {
                return "IZPX";
            }
            case indirectZeropageY: {
                return "IZPY";
            }
            case absolute: {
                return "ABS";
            }
            case absoluteX: {
                return "ABSX";
            }
            case absoluteY: {
                return "ABSY";
            }
            case indirect: {
                return "IND";
            }
            case relative: {
                return "REL";
            }
        }
        return "Unknown type";
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function1Arg("asmCommandSize", NumberValue.invalid, (value, sourceRange) -> new NumberValue(this.getOpcodeSize(value.getInt((SourceRange)sourceRange)))));
        return arrayList;
    }
}

